<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeamPerson extends Model 
{

    protected $table = 'team_persons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'position_ar', 'position_en', 'desc_ar', 'desc_en', 'image', 'team_id');
    protected $visible = array('name_ar', 'name_en', 'position_ar', 'position_en', 'desc_ar', 'desc_en', 'image', 'team_id');

    public function team()
    {
        return $this->belongsTo('App\Models\Team', 'team_id');
    }

}